function Sizes(){
	this.width = 0;
	this.height = 0;
	var resize_Top = $("#resize-Top");
	var resize_Left = $("#resize-Left");
	var resize_Right = $("#resize-Right");
	var whole_RNA = $("#whole-RNA");
	var body_width = $("body");
	
	
	load = function(){
		this.width = $("body").width();
		this.height = $(window).height();
		resize_Top.width(this.width);
		resize_Top.height(Math.floor(this.height/3));
		resize_Left.width(Math.floor(this.width/2));
		resize_Left.height(Math.floor(this.height/3) * 2);
		resize_Right.width(Math.floor(this.width/2) - 3);
		resize_Right.height(Math.floor(this.height/3) * 2);
		dezign();
		positionOfRNA();
		setTab2SizeOnResize();
	}
	
	function dezign(){
		$(document).tooltip({
			position: { my: 'center bottom', at: 'center top-10' }
		});
		$(".accordion").accordion();
		$("#tab").tabs();
		$("#add-sequence").hide();
		$("#sequence-details").hide();
	}
	
	function setTab2SizeOnResize(){
		$("#tab-1").height($("#tab").height() - 55);
		$("#tab-2").height($("#tab").height() - 48);
		$("#sequence-details .ui-accordion-content").height($("#tab-2").height() - 45);  
		$("#add-sequence .ui-accordion-content").height($("#tab-2").height() - 100);  
	}
	
	function resizes(){
		$("#resize-Top").resizable({
			maxHeight: maxSize(this.height),
			minHeight: 50,
			handles: 's',
			resize: function(event, ui) {
				resize_Left.height($(window).height() - ui.size.height);
				resize_Right.height(resize_Left.height());
				resize_Right.width(body_width.width() - resize_Left.width() - 3);
				positionOfRNA();
				setTab2SizeOnResize();
			}
		});
		
		$("#resize-Left").resizable({
			maxWidth: maxSize(this.width),
			minWidth: minSize(this.width),
			handles: 'e',
			resize: function(event, ui) {
				resize_Right.width(body_width.width() - ui.size.width - 3);
			}
		});
	}
		
		
	function windowResizes(){
		$(window).on('resize', function(){
			var new_winow_width = $(window).width();
			var new_winow_height = $(window).height();
			if (new_winow_width !== this.width) {
				resizeWidth(new_winow_width);
			}
			if (new_winow_height !== this.height) {
				resizeHeight(new_winow_height);
			}
		});
		
		resizeWidth = function(new_winow_width){
			var difference_in_width = Math.floor((new_winow_width - this.width) / 2);
			resize_Top.width(new_winow_width);
			resize_Left.width(resize_Left.width() + difference_in_width);
			resizeRightWidth();
			this.width = new_winow_width; 
			resize_Left.resizable("option", "minWidth", minSize(this.width));
			resize_Left.resizable("option", "maxWidth", maxSize(this.width));
		}
		
		resizeHeight = function(new_winow_height){
			var difference_in_height = (new_winow_height - this.height) / 2;
			this.height = new_winow_height;
			resize_Top.height(resize_Top.height() + difference_in_height);
			resize_Left.height(this.height - resize_Top.height());
			resize_Right.height(resize_Left.height());
			resizeRightWidth();
			positionOfRNA()
			setTab2SizeOnResize();
			resize_Top.resizable("option", "maxHeight", maxSize(this.height));
		}
		
		resizeRightWidth = function(){
			resize_Right.width(body_width.width() - resize_Left.width() - 3);
		}
	}	
	
	maxSize = function(size){
		return Math.floor(size/3 * 2);
	}
		
	minSize = function(size){
		return Math.floor(size/3);
	}
	
	positionOfRNA = function(){
		var pos_whole_RNA = Math.floor(resize_Top.height()/2);
		whole_RNA.css("top", pos_whole_RNA + "px");
	}
	
	function fontSize(){
		var minSize = 10;
		var maxSize = 35;
		var size = 15;			
		$('#resize-Top').on('mousewheel DOMMouseScroll', function(e) {
			var scrollValue = 0;
			if(typeof e.originalEvent.wheelDelta === "number"){  // Chrome, Opera ... (mousewheel)
				scrollValue = e.originalEvent.wheelDelta;
			}else {												 // Firefox	(DOMMouseScroll)
				scrollValue = -e.originalEvent.detail;
			}
			
			if(scrollValue > 0 && size < maxSize) {
				size += 1;
			} else if (scrollValue < 0 && size > minSize){
				size -= 1;
			}
			whole_RNA.css("font-size", size + "px");
		});
	}	
	
	load();
	resizes();
	windowResizes();
	fontSize();	
}
  